package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.sorting.PatientSortingAlgorithm;
import com.agilex.healthcare.utility.DateHelper;

public class PatientSortingAlgorithmTest {
	private static final int EQUAL_TO = 0;
	private static final int GREATER_THAN = 1;
	private static final int LESS_THAN = -1;
	private PatientSortingAlgorithm comparer = new PatientSortingAlgorithm();

	@Test(expected = NullPointerException.class)
	public void comparePatientWithNull() {
		Patient a = createPatient("a", null, null, null);
		Patient b = null;

		comparer.compare(a,b);
	}

	@Test(expected = NullPointerException.class)
	public void compareNullwithPatient() {
		Patient a = null;
		Patient b = createPatient("b", null, null, null);

		comparer.compare(a,b);
	}

	
	@Test
	public void compareLastNameAtoB() {
		Patient a = createPatient("a", null, null, null);
		Patient b = createPatient("b", null, null, null);

		assertEquals(LESS_THAN, comparer.compare(a,b));
	}

	@Test
	public void compareLastNameBtoA() {
		Patient a = createPatient("a", null, null, null);
		Patient b = createPatient("b", null, null, null);

		assertEquals(GREATER_THAN, comparer.compare(b,a));
	}

	@Test
	public void compareLastNameAtoA() {
		Patient a1 = createPatient("a", null, null, null);
		Patient a2 = createPatient("a", null, null, null);

		assertEquals(EQUAL_TO, comparer.compare(a1,a2));
	}

	@Test
	public void compareFirstNameAtoB() {
		Patient a = createPatient("lastname", "a", null, null);
		Patient b = createPatient("lastname", "b", null, null);

		assertEquals(LESS_THAN, comparer.compare(a,b));
	}

	@Test
	public void compareFirstNameBtoA() {
		Patient a = createPatient("lastname", "a", null, null);
		Patient b = createPatient("lastname", "b", null, null);

		assertEquals(GREATER_THAN, comparer.compare(b,a));
	}

	@Test
	public void compareFirstNameAtoA() {
		Patient a1 = createPatient("lastname", "a", null, null);
		Patient a2 = createPatient("lastname", "a", null, null);

		assertEquals(EQUAL_TO, comparer.compare(a1,a2));
	}

	@Test
	public void compareDobAtoB() {
		Patient a = createPatient("lastname", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("lastname", "firstname", DateHelper.parseDate("1/1/1980"), null);

		assertEquals(LESS_THAN, comparer.compare(a,b));
	}

	@Test
	public void compareDobBtoA() {
		Patient a = createPatient("lastname", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient b = createPatient("lastname", "firstname", DateHelper.parseDate("1/1/1980"), null);

		assertEquals(GREATER_THAN, comparer.compare(b,a));
	}

	@Test
	public void compareDobAtoA() {
		Patient a1 = createPatient("lastname", "firstname", DateHelper.parseDate("1/1/1970"), null);
		Patient a2 = createPatient("lastname", "firstname", DateHelper.parseDate("1/1/1970"), null);

		assertEquals(EQUAL_TO, comparer.compare(a1,a2));
	}

	@Test
	public void compareSsnAtoB() {
		Patient a = createPatient("a", null, null, "111111111");
		Patient b = createPatient("a", null, null, "222222222");

		assertEquals(LESS_THAN, comparer.compare(a,b));
	}

	@Test
	public void compareSsnBtoA() {
		Patient a = createPatient("a", null, null, "111111111");
		Patient b = createPatient("a", null, null, "222222222");

		assertEquals(GREATER_THAN, comparer.compare(b,a));
	}

	@Test
	public void compareSsnAtoA() {
		Patient a1 = createPatient("a", null, null, "111111111");
		Patient a2 = createPatient("a", null, null, "111111111");

		assertEquals(EQUAL_TO, comparer.compare(a1, a2));
	}

	private Patient createPatient(String lastname, String firstname, Date dob, String ssn) {
		SortingPatientsTest helper = new SortingPatientsTest();
		return helper.createPatient(lastname, firstname, dob, ssn);
	}
}
