package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class PatientIdentifierTest {

	@Test
	public void serializePatientIdentifier() {
		PatientIdentifier p = new PatientIdentifier("1.1", "MRN-1");
		assertEquals("1.1#MRN-1", p.toString());
	}

	@Test
	public void serializePatientIdentifierNoAssigningAuthority() {
		PatientIdentifier p = new PatientIdentifier("", "MRN-1");
		assertEquals("MRN-1", p.toString());
	}

	@Test
	public void serializePatientIdentifierNoPatient() {
		PatientIdentifier p = new PatientIdentifier("1.1", "");
		assertEquals(null, p.toString());
	}

	@Test
	public void serializePatientIdentifierNoData() {
		PatientIdentifier p = new PatientIdentifier("", "");
		assertEquals(null, p.toString());
	}
	
	@Test
	public void validateEquals(){
		PatientIdentifier pi1 = new PatientIdentifier("ICN", "D123401");
		PatientIdentifier pi2 = new PatientIdentifier("ICN", "D123401");
		
		assertTrue(pi1.equals(pi2));
	}

	@Test
	public void validateEqualsWhenIdentifiersAreNotEqual(){
		PatientIdentifier pi1 = new PatientIdentifier("ICN", "123401");
		PatientIdentifier pi2 = new PatientIdentifier("ICN", "D123401");
		
		assertFalse(pi1.equals(pi2));
	}

	@Test
	public void validateEqualsWhenAssigningAuthoritiesContainICN(){
		PatientIdentifier pi1 = new PatientIdentifier("ICN-123", "D123401");
		PatientIdentifier pi2 = new PatientIdentifier("ICN", "D123401");
		
		assertTrue(pi1.equals(pi2));
	}
	
	@Test
	public void validateEqualsWhenAssigningAuthoritiesContainICN_DifferentData(){
		PatientIdentifier pi1 = new PatientIdentifier("ICN-123", "D123401");
		PatientIdentifier pi2 = new PatientIdentifier("ICN-234", "D123401");
		
		assertTrue(pi1.equals(pi2));
	}

	@Test
	public void validateEqualsWhenOnePIHasICNAndOtherDoesNotContainICN(){
		PatientIdentifier pi1 = new PatientIdentifier("EDIPI", "D123401");
		PatientIdentifier pi2 = new PatientIdentifier("ICN-234", "D123401");
		
		assertFalse(pi1.equals(pi2));
	}

}
