package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class PatientIdentifierEqualsTest {
	@Test
	public void compareToNonPatientIdentifier() {
		PatientIdentifier p = new PatientIdentifier("a", "1");
		assertEquals(false, p.equals(""));
	}

	@Test
	public void equalsNull() {
		runTest(new PatientIdentifier("a", "1"), null, false);
	}

	@Test
	public void nullAssigningAuthority() {
		runTest(new PatientIdentifier("a", "1"), new PatientIdentifier(null, "1"), false);
	}

	@Test
	public void bothNullAssigningAuthority() {
		runTest(new PatientIdentifier(null, "1"), new PatientIdentifier(null, "1"), true);
	}

	@Test
	public void nullId() {
		runTest(new PatientIdentifier("a", "1"), new PatientIdentifier("a", null), false);
	}

	@Test
	public void bothNullId() {
		runTest(new PatientIdentifier("a", null), new PatientIdentifier("a", null), true);
	}

	@Test
	public void bothNull() {
		runTest(new PatientIdentifier(null, null), new PatientIdentifier(null, null), true);
	}

	@Test
	public void equal() {
		runTest(new PatientIdentifier("a", "1"), new PatientIdentifier("a", "1"), true);
	}

	private void runTest(PatientIdentifier a, PatientIdentifier b, boolean expectedResult) {
		assertEquals(expectedResult, a.equals(b));
	}
}
