package com.agilex.healthcare.mobilehealthplatform.domain;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class AppointmentsTest {

	@Test
	public void filterAppointments() {
		Appointments appointments = new Appointments();
		assertEquals(appointments.size(), appointments.filterByStatusCodes(null).size());
	}
	
	@Test
	public void filterAppointmentsByAStatusCode() {
		Appointments appointments = new Appointments();
		assertEquals(appointments.size(), appointments.filterByStatusCodes(new String[]{"R"}).size());
	}
	
	@Test
	public void filterAppointmentsByKeptStatusCode() {
		Appointments appointments = new Appointments();

		Appointment appointment1 = new Appointment();
		appointment1.setStatusCode("R");
		appointments.add(appointment1);

		Appointment appointment2 = new Appointment();
		appointment2.setStatusCode("NS");
		appointments.add(appointment2);

		Appointment appointment3 = new Appointment();
		appointment3.setStatusCode("NSR");
		appointments.add(appointment3);
		
		assertEquals(1, appointments.filterByStatusCodes(new String[]{"R"}).size());
	}
	
	@Test
	public void filterAppointmentsByKeptandNoShowRescheduledStatusCode() {
		Appointments appointments = new Appointments();

		Appointment appointment1 = new Appointment();
		appointment1.setStatusCode("R");
		appointments.add(appointment1);

		Appointment appointment2 = new Appointment();
		appointment2.setStatusCode("NS");
		appointments.add(appointment2);

		Appointment appointment3 = new Appointment();
		appointment3.setStatusCode("NSR");
		appointments.add(appointment3);
		
		assertEquals(2, appointments.filterByStatusCodes(new String[]{"R", "NSR"}).size());
	}
	
}
