package com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary;


import java.util.Date;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphDataSeries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryReport;
import com.agilex.healthcare.utility.DateHelper;

/**
 * Created with IntelliJ IDEA.
 * User: clarkee
 * Date: 9/26/12
 * Time: 3:14 PM
 * To change this template use File | Settings | File Templates.
 */
public class PainSummaryGraphGeneratorTest {

    @Test
    public void canCallGenerator(){
        PainDiaryEntries painDiaryEntries = new PainDiaryEntries();
        AssessmentResults assessmentResults = new AssessmentResults();

        PainSummaryGraphGenerator generator = new PainSummaryGraphGenerator();
        GraphData graphData = generator.createGraphData(painDiaryEntries, assessmentResults);

        Assert.assertNotNull(graphData);
    }

    @Test
    public void painEntriesDateTimeDistinguishable(){
        PainDiaryEntry entry= new PainDiaryEntry();
        Date baseDate = DateHelper.parseDate("06/01/2012");
        entry.setDateCreated(DateHelper.plusMinutes(baseDate, 20));

        PainDiaryEntry entryLate = new PainDiaryEntry();
        entryLate.setDateCreated(DateHelper.plusMinutes(baseDate, 40));

        Assert.assertNotSame(entry.getDateCreated(), entryLate.getDateCreated());
    }

    @Test
    public void graphReturnsLatestEntryOfDay(){
        PainDiaryEntries entries = new PainDiaryEntries();

        PainDiaryEntry entryOne = createPainDiaryEntry(20, "10", DateHelper.parseDate("06/01/2012"));
        PainDiaryEntry entryLate = createPainDiaryEntry(40, "8", DateHelper.parseDate("06/01/2012"));

        entries.add(entryOne);
        entries.add(entryLate);

        PainSummaryGraphGenerator generator = new PainSummaryGraphGenerator();
        GraphData graphData = generator.createGraphData(entries, null);

        GraphDataSeries series = graphData.getDataSeriesCollection().get(0);
        Assert.assertEquals(1, series.size());
    }

    @Test
    public void graphReturnsLatestEntryOfDayWithTwoDaysData(){
        PainDiaryEntries entries = new PainDiaryEntries();

        addEntry(entries, "10", "06/01/2012", 20);
        addEntry(entries, "8", "06/01/2012", 40);

        addEntry(entries, "10", "06/02/2012", 20);
        addEntry(entries, "8", "06/02/2012", 40);

        PainSummaryGraphGenerator generator = new PainSummaryGraphGenerator();
        GraphData graphData = generator.createGraphData(entries, null);

        GraphDataSeries series = graphData.getDataSeriesCollection().get(0);
        Assert.assertEquals(2, series.size());
    }

    private void addEntry(PainDiaryEntries entries, String painIntensity, String date, int plusMinutes) {
        Date parsedDate = DateHelper.parseDate(date);
        PainDiaryEntry entryLate = createPainDiaryEntry(plusMinutes, painIntensity, parsedDate);
        entries.add(entryLate);
    }

    PainDiaryEntry createPainDiaryEntry(int plusMinutes, String painIntensity, Date parsedDate){
        PainDiaryEntry entry= new PainDiaryEntry();
        Date baseDate = parsedDate;
        entry.setDateCreated(DateHelper.plusMinutes(baseDate, plusMinutes));
        entry.setPainQuestionValues(new PainDiaryReport());

        entry.getPainQuestionValues().setAveragePainIntensity(painIntensity);
        return entry;
    }
}
