package com.agilex.healthcare.mobilehealthplatform.datalayer.learn;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCondition;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnSubCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnSubCategory;

public class LearnDataLayerFileTest {
	LearnDataLayer datalayer = new LearnDataLayerFile();

	@Test
	public void loadConditions() {
		LearnConditions conditions = datalayer.fetchLearnConditions();

		assertNotNull(conditions);
		assertTrue(conditions.size() > 0);
	}

	@Test
	public void fetchLearnCategoriesByCondition() {
		LearnCondition validCondition = new LearnCondition();
		validCondition.setId("condition1");
		LearnCategories categories = datalayer.fetchLearnCategories(validCondition);

		assertEquals(3, categories.size());
		assertEquals("Learn about Category A", categories.getCategoryById("categoryA").getTitle());
		assertEquals("Learn about Category B", categories.getCategoryById("categoryB").getTitle());
		assertEquals("Learn about Category C", categories.getCategoryById("categoryC").getTitle());
	}

	@Test(expected = RuntimeException.class)
	public void fetchLearnCategoriesByInvalidCondition() {
		LearnCondition invalidCondition = new LearnCondition();
		invalidCondition.setId("invalid");
		datalayer.fetchLearnCategories(invalidCondition);
	}

	@Test
	public void fetchLearnCategoryById() {
		LearnCategory category = datalayer.fetchLearnCategory("categoryA");
		LearnSubCategory subcategory1 = category.getSubCategories().getSubCategoryById("subcat1");
		LearnSubCategory subcategory2 = category.getSubCategories().getSubCategoryById("subcat2");

		assertEquals("Learn about Category A", category.getTitle());
		assertEquals(2, category.getNumberOfSubCategories());
		assertEquals("SubCategory 1", subcategory1.getTitle());
		assertEquals(2, subcategory1.getNumberOfArticles());
		assertEquals("What is Article A about?", subcategory1.getArticles().getArticleById("articleA").getTitle());
		assertEquals("What is Article B about?", subcategory1.getArticles().getArticleById("articleB").getTitle());
		assertEquals("SubCategory 2", subcategory2.getTitle());
		assertEquals(2, subcategory2.getNumberOfArticles());
		assertEquals("What is Article C about?", subcategory2.getArticles().getArticleById("articleC").getTitle());
		assertEquals("What is Article D about?", subcategory2.getArticles().getArticleById("articleD").getTitle());
	}

	
	@Test
	public void fetchChaplainArticleById(){
		LearnCategory category = datalayer.fetchLearnCategory("learnAboutProfessionalCare");
		LearnSubCategory subCat = category.getSubCategories().getSubCategoryById("learnAboutProfessionalCare-learnAboutProfessionalCare");
		LearnArticle article = subCat.getArticles().getArticleById("whatDoesAPastoralCounselorOrChaplainDo");
		
		assertNotNull(article);
		assertEquals("Pastoral Counselors",  article.getTitle());
	}
	
	@Test
	public void fetchPainLearnSection(){
		LearnCategory category = datalayer.fetchLearnCategory("painBasics");
		assertNotNull(category);
		assertEquals(1,  category.getSubCategories().size());
		LearnSubCategories subCategories = category.getSubCategories();
		LearnSubCategory subCat = subCategories.getSubCategoryById("painBasics");
		assertNotNull(subCat);
		assertEquals(22,  subCat.getArticles().size());
		
		category = datalayer.fetchLearnCategory("painGoals");
		assertNotNull(category);
		assertEquals(1,  category.getSubCategories().size());
		subCategories = category.getSubCategories();
		subCat = subCategories.getSubCategoryById("painGoals");
		assertNotNull(subCat);
		assertEquals(4, subCat.getArticles().size());

		
		category = datalayer.fetchLearnCategory("painSkills");
		assertNotNull(category);
		assertEquals(2,  category.getSubCategories().size());
		subCategories = category.getSubCategories();
		subCat = subCategories.getSubCategoryById("painSkillsEducation");
		assertNotNull(subCat);
		assertEquals(6, subCat.getArticles().size());
        subCat = subCategories.getSubCategoryById("painSkillsInteractive");
        assertNotNull(subCat);
        assertEquals(8, subCat.getArticles().size());

    }
	
	
	@Test
	public void fetchCategoryLearnAboutProfessionalCare() {
		LearnCategory category = datalayer.fetchLearnCategory("learnAboutProfessionalCare");
		assertNotNull(category);
		assertEquals(1, category.getNumberOfSubCategories());
	}

	@Test
	public void fetchCategoryLearnAboutPTSD() {
		LearnCategory category = datalayer.fetchLearnCategory("learnAboutPTSD");
		assertNotNull(category);
		assertTrue(category.getNumberOfSubCategories() > 0);
	}
	
	@Test(expected = RuntimeException.class)
	public void fetchLearnCategoryByInvalidId() {
		datalayer.fetchLearnCategory("invalid");
	}

	@Test
	public void fetchLearnArticleById() {
		LearnArticle article = datalayer.fetchLearnArticle("articleA");

		assertNotNull(article);
		assertEquals("What is Article A about?", article.getTitle());
		assertEquals("Article A provides information about the letter A.", article.getContent());
	}

	@Test(expected = RuntimeException.class)
	public void fetchLearnArticleByInvalidId() {
		datalayer.fetchLearnArticle("invalid");
	}
}