package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.UUID;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphDataSeries;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.utility.DateHelper;

public class AssessmentResultGraphGeneratorTest {
	private AssessmentResultGraphGenerator graphGenerator = new AssessmentResultGraphGenerator();
	String patientId = UUID.randomUUID().toString();
	String testAssessmentId = "testAssessmentId";
	Date sixMonthsAgo = DateHelper.minusMonths(DateHelper.getToday(), 6);
	Date today = DateHelper.getToday();

	@Test
	public void convertEmpty() {
		AssessmentResults assessmentResults = new AssessmentResults();
		GraphData graphData = graphGenerator.createGraphData(assessmentResults);
		assertNotNull(graphData);
	}

	@Test
	public void convertSimpleDataSet() {
		AssessmentResults assessmentResults = generateMockResults();
		GraphData graphData = graphGenerator.createGraphData(assessmentResults);

		GraphDataSeries scoreDataSeries = getGraphDataSeries(graphData);
		assertEquals(4, scoreDataSeries.getSize());
		assertTrue(1 == scoreDataSeries.getMinY());
		assertTrue(4 == scoreDataSeries.getMaxY());
		assertTrue(DateHelper.dateToSeconds(sixMonthsAgo) == scoreDataSeries.getMinX());
		assertTrue(DateHelper.dateToSeconds(today) == scoreDataSeries.getMaxX());
	}

	private GraphDataSeries getGraphDataSeries(GraphData graphData) {
		assertNotNull(graphData);
		assertEquals(1, graphData.getDataSeriesCollection().size());
		GraphDataSeries scoreDataSeries = graphData.getDataSeriesCollection().get(0);
		assertEquals("Assessment Result Scores", scoreDataSeries.getTitle());
		return scoreDataSeries;
	}

	private AssessmentResults generateMockResults() {
		AssessmentResults results = new AssessmentResults();
		AssessmentResult assessmentResult = generateMockAssessmentResult(1, sixMonthsAgo, false);
		results.add(assessmentResult);
		assessmentResult = generateMockAssessmentResult(4, today, false);
		results.add(assessmentResult);
		assessmentResult = generateMockAssessmentResult(3, DateHelper.getYesterday(), false);
		results.add(assessmentResult);
		assessmentResult = generateMockAssessmentResult(2, DateHelper.getPreviousMonth(), false);
		results.add(assessmentResult);
		return results;
	}

	private AssessmentResult generateMockAssessmentResult(int score, Date dateTaken, boolean inProgress) {
		AssessmentResult assessmentResult = new AssessmentResult();
		assessmentResult.setPatientId(patientId);
		assessmentResult.setDateTaken(dateTaken);
		assessmentResult.setAssessmentId(testAssessmentId);
		assessmentResult.setUniqueTitle(UUID.randomUUID().toString());
		assessmentResult.setUniqueId(UUID.randomUUID().toString());
		assessmentResult.setVersion("1.0");
		assessmentResult.setAuthenticationStrategy(AssessmentCode.AUTHENTICATION_STRATEGY_ANONYMOUS);
		assessmentResult.setNotes("test data for notes");
		assessmentResult.setScore(score);
		assessmentResult.setScoringAlgorithm(AssessmentCode.SCORING_ALGORITHM_UNSCORED);
		assessmentResult.setInProgress(inProgress);
		assessmentResult.setWaitingPeriod(7);
		return assessmentResult;
	}
}
