package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestion;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessments;

public class AssessmentDataLayerFileTest {
	private AssessmentDataLayer datalayer = new AssessmentDataLayerFile();
	
	@Test
	public void loadAssessment() {
		Assessment clinicInHandAssessment = datalayer.fetchAssessment("A1");	
		assertEquals("Clinic in Hand Pilot Demographics", clinicInHandAssessment.getUniqueTitle());
	}

	@Test
	public void loadActiveAssessments() {
		Assessments activeAssessments = datalayer.fetchActiveAssessments();
		assertEquals(8,activeAssessments.size());
	}
	
	@Test
	public void loadHealthAssessmentAssessments() {
		Assessments assessmentsInHealthAssessment = datalayer.fetchAssessmentsForHealthAssessment();
		assertEquals(4, assessmentsInHealthAssessment.size());
		assertTrue(assessmentsContainsAssessmentId(assessmentsInHealthAssessment, "A1"));
		assertTrue(assessmentsContainsAssessmentId(assessmentsInHealthAssessment, "A2"));
		assertTrue(assessmentsContainsAssessmentId(assessmentsInHealthAssessment, "A3"));
        assertTrue(assessmentsContainsAssessmentId(assessmentsInHealthAssessment, "A4"));
	}

	private boolean assessmentsContainsAssessmentId(Assessments assessmentsInHealthAssessment, String assessmentId) {
		for (Assessment assessment : assessmentsInHealthAssessment) {
			if (assessment.getId().equals(assessmentId)) {
				return true;
			}
		}
		return false;
	}

	@Test
	public void loadMonthlyPainAssessment(){
		Assessment clinicInHandAssessment = datalayer.fetchAssessment("monthlyPain");	
		assertEquals("Monthly Pain Assessment", clinicInHandAssessment.getUniqueTitle());
		assertEquals(30, clinicInHandAssessment.getWaitingPeriod());
		assertNotNull(clinicInHandAssessment.getNotes());
	}
	
	@Test
	public void loadPTSDAssessment() {
		Assessment clinicInHandAssessment = datalayer.fetchAssessment("ptsd");	
		assertEquals("PTSD Assessment", clinicInHandAssessment.getUniqueTitle());
	}

	@Test
	public void loadMultipleChoiceQuestion() {
		AssessmentQuestion multipleChoiceQuestion = datalayer.fetchQuestion("A1", "Q1");
		assertNotNull(multipleChoiceQuestion);
		assertEquals("How old are you?", multipleChoiceQuestion.getPrompt());
		assertEquals(6, multipleChoiceQuestion.getQuestionChoices().size());
		assertEquals(0, multipleChoiceQuestion.getQuestionProperties().size());
	}

	@Test
	public void loadSliderQuestion() {
		AssessmentQuestion sliderQuestion = datalayer.fetchQuestion("A1", "Q13");
		assertNotNull(sliderQuestion);
		assertEquals("On this scale, rate yourself on your computer skills and capabilities.", sliderQuestion.getPrompt());
		assertEquals(5, sliderQuestion.getQuestionProperties().size());
		assertEquals(0, sliderQuestion.getQuestionChoices().size());
	}
}