package com.agilex.healthcare.utility.datemarshallers;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Whitelist;


public class XSSProtectionMapper extends XmlAdapter<String, String>  {

    @Override
    public String marshal(String output) throws Exception {
    	String encoded = null;
    	if (output != null){
    		Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
			encoded = Jsoup.clean(output, "", Whitelist.basic(), outputSettings);
    	}
    	if (encoded != null) {
    		encoded = unescapeValidCharacters(encoded);
    	}
        return encoded;
    }

    /**
     * Unescaping some white list chars using String replace.
     * 
     * @param encoded
     * @return
     */
    private String unescapeValidCharacters(String encoded) {
    	String updatedStr = encoded.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    	return updatedStr;
	}

	@Override
    public String unmarshal(String s) throws Exception {
        return s;
    }
	
}

