package com.agilex.healthcare.utility.datemarshallers;

import java.util.Date;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public abstract class AbstractDateMarshaller extends XmlAdapter<String, Date> {
	abstract protected String getDateFormat();

	@Override
	public String marshal(Date date) {
		String serializedDate;
		if (date != null) {
			serializedDate = DateHelper.format(date, getDateFormat());
		} else {
			serializedDate = getSerializedNullDate();
		}
		return serializedDate;
	}

	@Override
	public Date unmarshal(String dateStr) {
		Date dt = null;
		if (NullChecker.isNotNullish(dateStr)) {
			dt = DateHelper.parse(dateStr, getDateFormat());
		}
		return dt;
	}

	abstract protected String getSerializedNullDate();

}
