package com.agilex.healthcare.utility;

import com.thoughtworks.xstream.XStream;
import org.w3c.dom.*;

import javax.xml.XMLConstants;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;
import java.lang.reflect.*;

/**
 *
 * @author j.ray
 */
public class XmlHelper {
	public static String getNodeValue(Node node) {
		String value = null;
		if (node != null) {
			value = node.getNodeValue();
			if (value == null) {
				value = node.getTextContent();
			}
		}
		return value;
	}

	public static String xmlToString(Node node) {
		try {
			StringWriter stw = new StringWriter();
			TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
			Transformer serializer = factory.newTransformer();
			serializer.transform(new DOMSource(node), new StreamResult(stw));
			return stw.toString();
		} catch (Exception e) {
			throw new RuntimeException("Failed to serialize xml", e);
		}
	}

	public static Document loadXml(String xml) {
		return loadXml(StreamHelper.stringToStream(xml));
	}

	public static Document loadXml(InputStream stream) {
		Document doc;
		try {
			doc = getDocumentBuilder().parse(stream);
		} catch (Exception e) {
			throw new RuntimeException("Failed to serialize to xml", e);
		}

		return doc;
	}

	private static DocumentBuilder getDocumentBuilder() {
		DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();

		domFactory.setNamespaceAware(true);
		DocumentBuilder builder;
		try {
            domFactory.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
			builder = domFactory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			throw new RuntimeException("Unable to initialize document builder", e);
		}
		return builder;
	}

	public static String objectToXML(Object obj) {
        try {
            XStream xs = new XStream();
            xs.processAnnotations(obj.getClass());
            return xs.toXML(obj);
        } catch (Exception e) {
            return objectToXMLReflection(obj);
        }
	}

    private static String objectToXMLReflection(Object obj) {
        StringBuffer sbf = new StringBuffer("<?xml version='1.0' encoding='UTF-8'>");
        Class<? extends Object> theClass = obj.getClass();
        String className = theClass.getName();
        className = className.substring(className.lastIndexOf(".") + 1, className.length());
        sbf.append("<" + className);
        // Get all the fields declared in the class
        Field[] fieldList = theClass.getDeclaredFields();
        // Loop over all the fields and output their values
        for (int i = 0; i < fieldList.length; i++) {
            String fieldName = fieldList[i].getName();
            fieldList[i].setAccessible(true);
            try {
                Object fieldValue = fieldList[i].get(obj);
                if (Modifier.isFinal(fieldList[i].getModifiers()))
                    continue;
                else if (fieldValue != null && !(fieldValue instanceof java.util.Collection)
                        && !(fieldValue instanceof Object[])) {
                    // Append the field names and their corresponding values.
                    sbf.append(" " + fieldName + "='");
                    sbf.append(fieldValue);
                    sbf.append("'");
                }
            } catch (IllegalAccessException e) {
//                e.printStackTrace();
            }
        }
        sbf.append("/>");
        return sbf.toString();
    }
}
