package com.agilex.healthcare.utility;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "TriState")
@XmlEnum
public enum TriState {
    @XmlEnumValue("true")
	TRUE("true"), 
    @XmlEnumValue("false")
	FALSE("false"), 
    @XmlEnumValue("unknown")
	UNKNOWN("unknown");

	private final String value;

	TriState(String v) {
		value = v;
	}

	public String value() {
		return value;
	}
	
	@Override
	public String toString() {
		return value;
	}

	public static TriState fromValue(String v) {
        for (TriState c: TriState.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }}
