package com.agilex.healthcare.utility;

public class StringTruncator {
	/**
	 * Truncate String to max bytes if value exceeds max bytes
	 * @param value
	 * @param maxBytes
	 * @return
	 */
	public static String truncate(String value, int maxBytes) {
		int currentBytes = 0;
		
	    for (int i = 0; i < value.length(); i++) {
	        int skip = 0;
	        int more;
	        char c = value.charAt(i);

	        // ranges from http://en.wikipedia.org/wiki/UTF-8
	        if (c <= 0x007f) {
	            more = 1;
	        } else if (c <= 0x07FF) {
	            more = 2;
	        } else if (c <= 0xd7ff) {
	            more = 3;
	        } else if (c <= 0xDFFF) {
	            // surrogate area, consume next char as well
	            more = 4;
	            skip = 1;
	        } else {
	            more = 3;
	        }

	        if (currentBytes + more > maxBytes) {
	            return value.substring(0, i);
	        }
	        
	        currentBytes += more;
	        i += skip;
	    }
	    return value;
	}
}
