package com.agilex.healthcare.utility;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.StringBuilderWriter;

/**
 * 
 * @author j.ray
 */
public class StreamHelper {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(StreamHelper.class);

	private static final String UTF8 = "UTF-8";
    private static final long MAX_BYTES = 10485760; // 10 MB


	public static String streamToString(InputStream stream) {
		return streamToString(stream, false);
	}

	public static String streamToString(InputStream stream, boolean closeWhenComplete) {
        byte[] bytes = streamToBytes(stream, closeWhenComplete);
        return new String(bytes);
	}

	public static InputStream stringToStream(String s) {
		InputStream is;
		try {
			is = new ByteArrayInputStream(s.getBytes(UTF8));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
		return is;
	}

    public static byte[] streamToBytes(InputStream stream, boolean closeWhenComplete) {
        byte[] b;
        try {
            BoundedInputStream bounded = new BoundedInputStream(stream, MAX_BYTES);
            b = IOUtils.toByteArray(bounded);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            if(closeWhenComplete) {
                safeClose(stream);
            }
        }
        return b;
    }

	public static void safeClose(InputStream stream) {
		if (stream != null) {
			try {
				stream.close();
			} catch (Exception ex) {
				logger.error("Failed to release stream using safe close", ex);
			}
		}
	}
}
