package com.agilex.healthcare.utility;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class PatientIdentityHelper {
	
	public PatientIdentifier padIcn(PatientIdentifier patientIdentifier) {
		if(!isIcnAssigningAuthority(patientIdentifier)) return patientIdentifier;
		
		PatientIdentifier altered = patientIdentifier.createCopy();
		altered.setUniqueId(padWithZeros(patientIdentifier.getUniqueId()));
		return altered;
	}
	
	public PatientIdentifier truncateICN(PatientIdentifier patientIdentifier) {
		if(!isIcnAssigningAuthority(patientIdentifier)) return patientIdentifier;
		
		PatientIdentifier altered = patientIdentifier.createCopy();
		altered.setUniqueId(stripHash(patientIdentifier.getUniqueId()));
		return altered;
	}
	
	private boolean isIcnAssigningAuthority(PatientIdentifier patientIdentifier) {
		return "ICN".equalsIgnoreCase(patientIdentifier.getAssigningAuthority());
	}
	
	private String padWithZeros(String originalIcn) {
		StringBuilder sb = new StringBuilder("000000");
		sb.append(originalIcn);
		sb.append("000000");
		
		return sb.toString();
	}
	
	private String stripHash(String originalIcn) {
		
		int index = originalIcn.toLowerCase().indexOf("v");
		if(index <= 0)
			return originalIcn;
		
		return originalIcn.substring(0, index);
	}
}
