package com.agilex.healthcare.utility;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "PainGoalStatus")
@XmlEnum
public enum PainGoalStatus {
	@XmlEnumValue("Complete")
	PainGoalStatusComplete("Complete"),
	@XmlEnumValue("Active")
	PainGoalStatusActive("Active"),
	@XmlEnumValue("Deleted")
	PainGoalStatusDeleted("Deleted");

	
	private final String value;
	
	PainGoalStatus(String v) {
		value = v;
	}
	
	@Override
	public String toString() {
		return value;
	}
	
	public static PainGoalStatus fromValue(String v) {
		for (PainGoalStatus c: PainGoalStatus.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}
	
	public String value(){
		return value;
	} 
}
