package com.agilex.healthcare.utility;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "PainGoalEntryStatus")
@XmlEnum
public enum PainGoalEntryStatus {
	@XmlEnumValue("Complete")
	PainGoalEntryStatusComplete("Complete"),
	@XmlEnumValue("Active")
	PainGoalEntryStatusActive("Active");

	
	private final String value;
	
	PainGoalEntryStatus(String v) {
		value = v;
	}
	
	@Override
	public String toString() {
		
		return value;
	}
	
	public static PainGoalEntryStatus fromValue(String v) {
		for (PainGoalEntryStatus c: PainGoalEntryStatus.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}
	
	public String value(){
		return value;
	} 
}
