package com.agilex.healthcare.utility;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObjectCollection;

public class Paginator<T, Ts extends DomainTransferObjectCollection<T>> {

	private int pageNumber;
	private int pageSize;
	private int initialPageNumber;

	public Paginator(int pageNumber, int pageSize, int initialPageNumber) {
		this.pageNumber = pageNumber;
		this.pageSize = pageSize;
		this.initialPageNumber = initialPageNumber;
	}

	public void paginate(Ts ts, Ts fill) {
		int startIndex = calculatePageOffset();
		
		int rangeEnd = Math.min(ts.size(), pageSize+startIndex);

		for (int i = startIndex; i < rangeEnd; i++) {
			fill.add(ts.get(i));
		}
	}

	int calculatePageOffset() {
		if (pageNumber == 0)
			return pageNumber;
		else
			return (pageNumber - initialPageNumber) * pageSize;
	}

	public void setPageNumber(int pageNumber) {
		this.pageNumber = pageNumber;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public void setInitialPageNumber(int initialPageNumber) {
		this.initialPageNumber = initialPageNumber;
	}
}
