package com.agilex.healthcare.utility;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

import org.codehaus.jackson.map.ObjectMapper;

public class ObjectSerializer {
	public static <T> String serializeAsXml(T object) {
		String result;
		try {
			JAXBContext context = JAXBContext.newInstance(object.getClass());
			Marshaller marshaller = context.createMarshaller();
			StringWriter writer = new StringWriter();
			marshaller.marshal(object, writer);
			result = writer.toString();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return result;
	}

	@SuppressWarnings("unchecked")
	public static <T> T deserializeFromXml(String xml, Class<T> type) {
		T unmarshalledSpecificObject;
		try {
			JAXBContext context = JAXBContext.newInstance(type);
			Unmarshaller unmarshaller = context.createUnmarshaller();

            // Protect against external entities attack
            XMLInputFactory inputFactory = XMLInputFactory.newFactory();
            inputFactory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);
            inputFactory.setProperty(XMLInputFactory.SUPPORT_DTD, false);

			StringReader reader = new StringReader(xml);
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(reader);
			Object unmarshalledObject = unmarshaller.unmarshal(streamReader);
			unmarshalledSpecificObject = (T) unmarshalledObject;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return unmarshalledSpecificObject;
	}

	public static <T> String serializeAsJson(T object) {
		String result;
		try {
			ObjectMapper mapper = new ObjectMapper();
			result = mapper.writeValueAsString(object);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return result;
	}
}
