package com.agilex.healthcare.utility;

public class ModeHelper {
	public static boolean isMode(String... mode) {
		String runningMode = getCurrentMode();

		boolean foundMode = false;
		for (String singleMode : mode) {
			if (singleMode.equalsIgnoreCase(runningMode)) {
				foundMode = true;
				break;
			}
		}

		return foundMode;
	}

	public static String getCurrentMode() {
		String runningMode = System.getProperty("org.apache.cocoon.mode");
		return runningMode;
	}
	
	public static boolean isVeteranMode(){
		// Default mode is veteran
		String mode = getCurrentMode();
		if (mode != null && mode.contains("provider")){
			return false;
		}
		return true;
	}

	public static boolean isProviderMode(){
		// Default mode is veteran
		String mode = getCurrentMode();
		if (mode != null && mode.contains("provider")){
			return true;
		}
		return false;
	}
}
