package com.agilex.healthcare.utility;

import java.util.Comparator;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;

public class MedicationDateComparator implements Comparator<Medication> {

	private int LEFT_LT_RIGHT = -1;
	private int EQUAL = 0;
	private int RIGHT_LT_LEFT = 1;
	
	@Override
	public int compare(Medication left, Medication right) {
		if(NullChecker.isNullish(left.getEndDate()) || NullChecker.isNullish(right.getEndDate())) {
			if(NullChecker.isNullish(left.getEndDate()) && NullChecker.isNullish(right.getEndDate())) {
				return EQUAL;
			} else if(NullChecker.isNullish(left.getEndDate())) {
				return LEFT_LT_RIGHT;
			} else if(NullChecker.isNullish(right.getEndDate())) {
				return RIGHT_LT_LEFT;
			}
		}
		return left.getEndDate().compareTo(right.getEndDate());
	}

}
