package com.agilex.healthcare.utility;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "MealType")
@XmlEnum
public enum MealType {
	@XmlEnumValue("Breakfast")
	BREAKFAST("Breakfast"),
	@XmlEnumValue("Lunch")
	LUNCH("Lunch"),
	@XmlEnumValue("Dinner")
	DINNER("Dinner"),
	@XmlEnumValue("Snack")
	SNACK("Snack");
	
	private final String value;
	
	MealType(String v) {
		value = v;
	}
	
	@Override
	public String toString() {
		return value;
	}
	
	public static MealType fromValue(String v) {
		for (MealType c: MealType.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}
	
	public String value(){
		return value;
	} 
	
}
