package com.agilex.healthcare.utility;

import java.util.Date;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;

public class JodaDateHelper {
	public static long delta(Date a, Date b, DurationFieldType durationFieldType) {
		DateTime jodaDateA = new DateTime(a);
		DateTime jodaDateB = new DateTime(b);
		return delta(jodaDateA, jodaDateB, durationFieldType);
	}

	private static long delta(DateTime a, DateTime b,
			DurationFieldType durationFieldType) {

		
		Period period = new Period(a, b);
		return period.get(durationFieldType);
	}

	public static Long deltaDurationInMillis(Date a, Date b) {
		
		DateTime jodaDateA = new DateTime(a);
		DateTime jodaDateB = new DateTime(b);
		
		return deltaDurationInMillis(jodaDateA, jodaDateB);
	}
	
	private static long deltaDurationInMillis(DateTime a, DateTime b) {
		Duration duration = new Duration(a, b);
		return duration.getMillis();
	}
}