package com.agilex.healthcare.utility;

public class IntegerParser {
	public static Integer parseIntegerDefaultNull(String s) {
		return parseInteger(s, null);

	}

	public static Integer parseIntegerDefault0(String s) {
		return parseInteger(s, 0);

	}

	public static Integer parseInteger(String s, Integer defaultValue) {
		Integer result = defaultValue;

		if (NullChecker.isNotNullish(s)) {
			try {
				//todo: perhaps run a regex on it to determine if a number, rather than relying on exception
				result = Integer.parseInt(s);
			} catch (NumberFormatException ex) {
				// ignore error. If error occurs, we use the default value as the return value;
				result = defaultValue;
			}
		} else {
			// since s is null, we will use the default value instead of parsing it
			result = defaultValue;
		}

		return result;
	}
}
