package com.agilex.healthcare.utility;

import java.beans.PropertyEditorSupport;
import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;

public class CustomDOBDateEditor extends PropertyEditorSupport {
	
	private final String format;

	public CustomDOBDateEditor(String format) {
		this.format = format;
	}

	@Override
	public void setAsText(String paramString) throws IllegalArgumentException {
		Date date = DateHelper.parse(paramString, format);
		setValue(new DOBDate(date));
	}

	@Override
	public String getAsText() {
		DOBDate value = (DOBDate) getValue();

		String retValue = null;

		if (value != null) {
			retValue = value.toString();
		}

		return retValue;
	}
}
