package com.agilex.healthcare.utility;

public class BooleanParser {
	/**
	 * This method parses a boolean for true/false, on/off, yes/no, 1/0. This is
	 * case-insensitive. If none of these patterns are met, then the default
	 * value is returned
	 * 
	 * @param parameter
	 *            This is a string that will be parsed to looking for a
	 *            boolean-style value
	 * @param defaultvalue
	 *            If no boolean-style value is found, this value will be
	 *            returned
	 * @return This boolean value is returned based on parsing the parameter
	 */
	public static boolean parse(String parameter, boolean defaultvalue) {
		if (isTrue(parameter))
			return true;
		else if (isFalse(parameter))
			return false;
		else
			return defaultvalue;
	}

	/**
	 * This method parses a boolean for true/false, on/off, yes/no, 1/0. This is
	 * case-insensitive. If none of these patterns are met, then an
	 * IllegalArgumentException is thrown
	 * 
	 * @param parameter
	 *            This is a string that will be parsed to looking for a
	 *            boolean-style value
	 * @return This boolean value is returned based on parsing the parameter
	 */
	public static boolean parse(String parameter) {
		if (isTrue(parameter))
			return true;
		else if (isFalse(parameter))
			return false;
		else
			throw new IllegalArgumentException(String.format("Unable to parse string [%s] into a boolean", parameter));
	}

	private static boolean isTrue(String parameter) {
		return (parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1"));
	}

	private static boolean isFalse(String parameter) {
		return (parameter.equalsIgnoreCase("false") || parameter.equalsIgnoreCase("off") || parameter.equalsIgnoreCase("no") || parameter.equals("0"));
	}

}
