package com.agilex.healthcare.mobilehealthplatform.validator.vitals;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalObservation;
import com.agilex.healthcare.utility.NullChecker;

public class VitalValidatorHelper {
	public static final String ENTRYDATE_FIELD = "Entry Date";

	public static final String NOTES_FIELD = "notes";

	public static ValidationError validateEntryDate(Date entryDate) {
		ValidationError error = null;
		if (entryDate == null) {
			error = new ValidationError();
			error.setFieldName(ENTRYDATE_FIELD);
			error.setErrorMessage("Entry date is required.");
		}
		return error;
	}

	public static ValidationError validateObservationValueInRange(VitalEntry vitalEntry, String fieldName, String observationTypeCode, Double min, Double max) {
		VitalObservation observation = vitalEntry.getObservationByType(observationTypeCode);
		ValidationError error = null;
		if (observation == null || NullChecker.isNullish(observation.getValue())) {
			error = new ValidationError(String.format("%s field is required.", fieldName), fieldName);
		} else {
			try {
				Double observationValue = observation.getValueAsDouble();
				if (observationValue < min) {
					String tooLowMessage = String.format("%s field must be between %s and %s", fieldName, min, max);
					error = new ValidationError(tooLowMessage, fieldName);
				} else if (observationValue > max) {
					String tooHighMessage = String.format("%s field must be between %s and %s", fieldName, min, max);
					error = new ValidationError(tooHighMessage, fieldName);
				}
			} catch (Exception ex) {
				error = new ValidationError(String.format("%s field must be numeric", fieldName), fieldName);
			}
		}
		return error;
	}

	public static ValidationError validateNotNull(VitalEntry vitalEntry, String vitalType) {
		ValidationError error = null;
		if (vitalEntry == null) {
			error = new ValidationError(String.format("%s vital entry object is required.", vitalType), vitalType);
		}
		return error;
	}
}
