package com.agilex.healthcare.mobilehealthplatform.validator.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;

public abstract class VitalValidator {
	public ValidationResult<VitalEntry> validate(VitalEntry vitalEntry) {
		ValidationResult<VitalEntry> validationResult = new ValidationResult<VitalEntry>();
		validationResult.setRequestObject(vitalEntry);

		if (vitalEntry == null) {
			validationResult.addIfNotNull(VitalValidatorHelper.validateNotNull(vitalEntry, getVitalType()));
		} else {
			validationResult.addIfNotNull(VitalValidatorHelper.validateEntryDate(vitalEntry.getEntryDate()));
			this.performSpecificValidation(validationResult, vitalEntry);
		}
		return validationResult;
	}

	abstract protected String getVitalType();

	abstract protected void performSpecificValidation(ValidationResult<VitalEntry> errors, VitalEntry vitalEntry);
}
