package com.agilex.healthcare.mobilehealthplatform.validator.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;

public class VitalTemperatureValidator extends VitalValidator {

	public static final String VitalType = "Temperature";
	public static final String TEMPERATURE_FIELD = "Temperature";

	private static final double TEMPERATURE_MAX = 106;
	private static final double TEMPERATURE_MIN = 95;

	@Override
	protected String getVitalType() {
		return VitalType;
	}

	@Override
	protected void performSpecificValidation(ValidationResult<VitalEntry> validationResult, VitalEntry vitalEntry) {
		validationResult.addIfNotNull(VitalValidatorHelper.validateObservationValueInRange(vitalEntry, TEMPERATURE_FIELD, ObservationTypeCode.BODY_TEMPERATURE, TEMPERATURE_MIN, TEMPERATURE_MAX));
	}
}
