package com.agilex.healthcare.mobilehealthplatform.validator.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;

public class VitalRespirationValidator extends VitalValidator {

	private static final String VitalType = "Respiration";
	private static final String Respiration_FieldName = "Respiration";
	private static final double Pain_Max = 60;
	private static final double Pain_Min = 4;

	@Override
	protected String getVitalType() {
		return VitalType;
	}

	@Override
	protected void performSpecificValidation(ValidationResult<VitalEntry> validationResult, VitalEntry vitalEntry) {
		validationResult.addIfNotNull(VitalValidatorHelper.validateObservationValueInRange(vitalEntry, Respiration_FieldName, ObservationTypeCode.RESPIRATION, Pain_Min, Pain_Max));
	}

}
