package com.agilex.healthcare.mobilehealthplatform.validator.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;

public class VitalPainValidator extends VitalValidator {

	private static final String VitalType = "Pain";
	private static final String Pain_FieldName = "Pain";
	private static final double Pain_Max = 10;
	private static final double Pain_Min = 0;

	@Override
	protected String getVitalType() {
		return VitalType;
	}

	@Override
	protected void performSpecificValidation(ValidationResult<VitalEntry> validationResult, VitalEntry vitalEntry) {
		validationResult.addIfNotNull(VitalValidatorHelper.validateObservationValueInRange(vitalEntry, Pain_FieldName, ObservationTypeCode.PAIN, Pain_Min, Pain_Max));
	}

}
