package com.agilex.healthcare.mobilehealthplatform.validator.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;

public class BloodPressureValidator extends VitalValidator {
	private static final String VitalEntryType = "VitalEntry";

	private static final double PULSE_HIGH_VALUE = 250;
	private static final double PULSE_LOW_VALUE = 40;

	private static final double DIASTOLIC_HIGH_VALUE = 160;
	private static final double DIASTOLIC_LOW_VALUE = 40;

	private static final double SYSTOLIC_LOW_VALUE = 60;
	private static final double SYSTOLIC_HIGH_VALUE = 220;

	private static final String SYSTOLIC_FIELDNAME = "Systolic blood pressure";
	private static final String DIASTOLIC_FIELDNAME = "Diastolic blood pressure";
	private static final String PULSE_FIELDNAME = "Pulse";

	@Override
	protected String getVitalType() {
		return VitalEntryType;
	}

	@Override
	protected void performSpecificValidation(ValidationResult<VitalEntry> validationResult, VitalEntry vitalEntry) {
		validationResult.addIfNotNull(VitalValidatorHelper.validateObservationValueInRange(vitalEntry, SYSTOLIC_FIELDNAME, ObservationTypeCode.INTRAVASCULAR_SYSTOLIC, SYSTOLIC_LOW_VALUE,
				SYSTOLIC_HIGH_VALUE));
		validationResult.addIfNotNull(VitalValidatorHelper.validateObservationValueInRange(vitalEntry, DIASTOLIC_FIELDNAME, ObservationTypeCode.INTRAVASCULAR_DIASTOLIC, DIASTOLIC_LOW_VALUE,
				DIASTOLIC_HIGH_VALUE));
		validationResult.addIfNotNull(VitalValidatorHelper.validateObservationValueInRange(vitalEntry, PULSE_FIELDNAME, ObservationTypeCode.HEART_BEAT, PULSE_LOW_VALUE, PULSE_HIGH_VALUE));
	}

}
