package com.agilex.healthcare.mobilehealthplatform.validator.mood;

import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.validator.Validator;
import com.agilex.healthcare.mobilehealthplatform.validator.ValidatorHelper;

public class MoodEventValidator implements Validator<MoodEvent> {

	private static final String EntryType = "Mood";
	private static final String DATE_FIELD = "Date";
	private static final String VALUE_FIELD = "Value";
	// private static final String NOTE_FIELD = "Notes";

	private static final String MOOD_EVENT_NULL = "MoodEvent must not be null";
	private static final String DATE_ERROR = "Date is required before a Mood Rating can be saved";
	// private static final String NOTE_ERROR =
	// "Notes must be 250 characters or less";

	private static final int MOOD_MIN = 0;
	private static final int MOOD_MAX = 10;

	@Override
	public ValidationResult<MoodEvent> validate(MoodEvent moodEvent) {

		ValidationResult<MoodEvent> validationResult = new ValidationResult<MoodEvent>();
		validationResult.setRequestObject(moodEvent);

		if (moodEvent == null) {
			validationResult.addIfNotNull(ValidatorHelper.validateIsNotNull(moodEvent, new ValidationError(EntryType, MOOD_EVENT_NULL)));
		} else {
			validationResult.addIfNotNull(ValidatorHelper.validateDateIsNotNull(moodEvent.getDate(), new ValidationError(DATE_FIELD, DATE_ERROR)));
			validationResult.addIfNotNull(ValidatorHelper.validateInclusiveNumericBounds(Integer.parseInt(moodEvent.getValue()), MOOD_MAX, MOOD_MIN,
					new ValidationError(VALUE_FIELD, String.format("Mood Rating can only be between %s and %s", MOOD_MIN, MOOD_MAX))));
			// validationResult.addIfNotNull(ValidatorHelper.validateInclusiveTextLength(moodEvent.getNotes(),
			// CHARACTER_MAX, new ValidationError(NOTE_FIELD, NOTE_ERROR)));
		}

		return validationResult;
	}

	// private static final int CHARACTER_MAX = 250;

	// public ValidationResult<MoodEvent> validate(MoodEvent moodEvent) {

	// }
}
