package com.agilex.healthcare.mobilehealthplatform.validator.medication;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;

public class RefillValidator {
	
	public ValidationResult<Medication> validate(Medication medication) {
		ValidationResult<Medication> validationResult = new ValidationResult<Medication>();
		validationResult.setRequestObject(medication);
		
		// The following code simulates a refill error for the medication "Abilify". It is used to verify that
		// a log file for prescription refill errors gets populated
		if (medication != null &&  "Abilify".equals(medication.getDrugName())) {
		  ValidationError validationError = new ValidationError();
		  validationError.setFieldName("");
		  validationError.setErrorMessage("Severe Error encountered refilling prescription for medication: " + medication.getDrugName());
		  validationResult.addIfNotNull(validationError);
		}
		return validationResult;
	}


}
