package com.agilex.healthcare.mobilehealthplatform.validator.exercise;

import com.agilex.healthcare.mobilehealthplatform.domain.Exercise;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.validator.Validator;
import com.agilex.healthcare.mobilehealthplatform.validator.ValidatorHelper;

public class ExerciseValidator implements Validator<Exercise> {

	public static final String EntryType = "Exercise";
	public static final String DATE_FIELD = "Date";
	public static final String DISTANCE_FIELD = "Distance";
	public static final String DURATION_FIELD = "Duration";
	public static final String NOTE_FIELD = "Notes";
	public static final String ACTIVITY_FIELD = "Activity";

	// public static final int NOTES_MAX = 250;

	public static final String EXERCISE_NULL = "Exercise must not be null";
	public static final String NOTES_ERROR = "Notes has a maximum of 250 characters";
	public static final String DISTANCE_ERROR = "Distance must be a positive numeric value";
	public static final String DURATION_ERROR = "Duration must be a positive numeric value";
	public static final String DATE_ERROR = "Date is required before an Exercise can be saved";
	public static final String ACTIVITY_ERROR = "Activity is required before an Exercise can be saved";

	public ValidationResult<Exercise> validate(Exercise exercise) {
		ValidationResult<Exercise> validationResult = new ValidationResult<Exercise>();
		validationResult.setRequestObject(exercise);

		if (exercise == null) {
			validationResult.addIfNotNull(ValidatorHelper.validateIsNotNull(exercise, new ValidationError(EntryType, EXERCISE_NULL)));
		} else {
			validationResult.addIfNotNull(ValidatorHelper.validateNonNegative(exercise.getDistance(), new ValidationError(DISTANCE_FIELD, DISTANCE_ERROR)));
			validationResult.addIfNotNull(ValidatorHelper.validateIsNotNull(exercise.getDuration(), new ValidationError(DURATION_FIELD, DURATION_ERROR)));
			validationResult.addIfNotNull(ValidatorHelper.validateNonNegative(exercise.getDuration(), new ValidationError(DURATION_FIELD, DURATION_ERROR)));
			validationResult.addIfNotNull(ValidatorHelper.validateDateIsNotNull(exercise.getDate(), new ValidationError(DATE_FIELD, DATE_ERROR)));
			validationResult.addIfNotNull(ValidatorHelper.validateIsNotBlankOrNull(exercise.getActivity(), new ValidationError(DISTANCE_FIELD, DISTANCE_ERROR)));
			// validationResult.addIfNotNull(ValidatorHelper.validateInclusiveTextLength(exercise.getNotes(),
			// NOTES_MAX, new ValidationError(NOTE_FIELD, NOTES_ERROR)));
		}

		return validationResult;
	}
}
