package com.agilex.healthcare.mobilehealthplatform.validator.diet;

import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.validator.Validator;

public class DietValidator implements Validator<DietEntry> {

	private static final String EntryType = "Diet Entry";

	public static final String FAT_FIELDNAME = "Fat";
	public static final String CARBS_FIELDNAME = "Carbohydrates";
	public static final String CALORIES_FIELDNAME = "Calories";
	public static final String PROTEIN_FIELDNAME = "Protein";
	
	@Override
	public ValidationResult<DietEntry> validate(DietEntry mealEntry) {
		ValidationResult<DietEntry> validationResult = new ValidationResult<DietEntry>();
		validationResult.setRequestObject(mealEntry);

		if (mealEntry == null) {
			validationResult.addIfNotNull(DietValidatorHelper.validateNotNull(mealEntry, EntryType));
		} else {
			validationResult.addIfNotNull(DietValidatorHelper.validateEntryDate(mealEntry.getEntryDate()));
			 performSpecificValidation(validationResult, mealEntry);
		}
		return validationResult;
	}

	protected void performSpecificValidation(ValidationResult<DietEntry> validationResult, DietEntry mealEntry) {
		validationResult.addIfNotNull(DietValidatorHelper.validateMealEntryValueWithinBounds(mealEntry, FAT_FIELDNAME));
		validationResult.addIfNotNull(DietValidatorHelper.validateMealEntryValueWithinBounds(mealEntry, CARBS_FIELDNAME));
		validationResult.addIfNotNull(DietValidatorHelper.validateMealEntryValueWithinBounds(mealEntry, CALORIES_FIELDNAME));
		validationResult.addIfNotNull(DietValidatorHelper.validateMealEntryValueWithinBounds(mealEntry, PROTEIN_FIELDNAME));
	}
}
