package com.agilex.healthcare.mobilehealthplatform.validator.dailyevents;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;

public class DailyEventValidatorHelper {

	private static final Integer MAX_TITLE_SIZE = 50;
	
	private static final String NOTES_IS_EMPTY = "An entry is required to save your daily event";
	private static final String DATE_IS_EMPTY = "Entry date is required";
	private static final String TITLE_IS_EMPTY = "Title is required";
	private static final String TITLE_IS_TOO_LARGE = String.format("Title must be less than %s characters", MAX_TITLE_SIZE);

	public static ValidationError validateNotes(String notes, String notesFieldname) {
		ValidationError error = null;
		if (notes != null && notes.length() == 0) {
			error = new ValidationError();
			error.setFieldName(notesFieldname);
			error.setErrorMessage(NOTES_IS_EMPTY);
		}
		return error;
	}

	public static ValidationError validateEntryDate(Date entryDate, String entryDateFieldname) {
		ValidationError error = null;
		if (entryDate == null) {
			error = new ValidationError();
			error.setFieldName(entryDateFieldname);
			error.setErrorMessage(DATE_IS_EMPTY);
		}
		return error;
	}

	public static ValidationError validateTitle(String title, String titleField) {
		ValidationError error = null;
		if (title == null || title.length() == 0) {
			error = new ValidationError();
			error.setFieldName(titleField);
			error.setErrorMessage(TITLE_IS_EMPTY);
		}
		if (title != null && title.length() > 50) {
			error = new ValidationError();
			error.setFieldName(titleField);
			error.setErrorMessage(TITLE_IS_TOO_LARGE);
		}
		return error;
	}

}
