package com.agilex.healthcare.mobilehealthplatform.validator.dailyevents;

import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.validator.Validator;

public class DailyEventValidator implements Validator<DailyEvent> {

	private static final String NOTES_FIELDNAME = "Notes";
	private static final String ENTRYDATE_FIELD = "Entry Date";
	private static final String TITLE_FIELD = "Title";

	@Override
	public ValidationResult<DailyEvent> validate(DailyEvent dailyEvent) {
		ValidationResult<DailyEvent> validationResult = new ValidationResult<DailyEvent>();
		validationResult.setRequestObject(dailyEvent);

		validationResult.addIfNotNull(DailyEventValidatorHelper.validateNotes(dailyEvent.getNotes(), NOTES_FIELDNAME));
		validationResult.addIfNotNull(DailyEventValidatorHelper.validateTitle(dailyEvent.getTitle(), TITLE_FIELD));
		validationResult.addIfNotNull(DailyEventValidatorHelper.validateEntryDate(dailyEvent.getEntryDate(), ENTRYDATE_FIELD));

		return validationResult;
	}

}
