package com.agilex.healthcare.mobilehealthplatform.validator.appointmentrequestmessage;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.utility.NullChecker;

public class AppointmentRequestMessageValidator {
    private int MAX_MESSAGE_TEXT_LENGTH = 100;
    private String MESSAGE_TEXT = "messageText";
    private ValidationResult<AppointmentRequestMessage>  validationResult;

    public ValidationResult<AppointmentRequestMessage> validate(AppointmentRequestMessage aptRequestMessage){
        validationResult = new ValidationResult<AppointmentRequestMessage>();

        validateMessageTexLength(aptRequestMessage.getMessageText());

        return validationResult;
    }

    private void validateMessageTexLength(String messageText) {
        if(NullChecker.isNullish(messageText) || !isMessageTextLengthValid(messageText)){
            validationResult.addIfNotNull(new ValidationError("Appointment request message is required and must be between 1 and " + MAX_MESSAGE_TEXT_LENGTH  + " characters.", MESSAGE_TEXT));
        }
    }

    private boolean isMessageTextLengthValid(String messageText){
        if(messageText.length() > 0 && messageText.length() <= MAX_MESSAGE_TEXT_LENGTH){
            return true;
        }
        return false;
    }




}
