package com.agilex.healthcare.mobilehealthplatform.validator;

import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.code.VitalSectionCode;
import com.agilex.healthcare.mobilehealthplatform.validator.dailyevents.DailyEventValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.BloodPressureValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.VitalHeightValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.VitalPainValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.VitalRespirationValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.VitalTemperatureValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.VitalValidator;
import com.agilex.healthcare.mobilehealthplatform.validator.vitals.VitalWeightValidator;

public class VitalValidatorFactory {
	public static VitalValidator getVitalsValdiator(VitalEntry vitalEntry) {
		return getVitalsValdiator(vitalEntry.getSection());
	}

	public static VitalValidator getVitalsValdiator(String sectionCode) {
		VitalValidator validator = null;
		if (sectionCode.contentEquals(VitalSectionCode.BloodPressure))
			validator = new BloodPressureValidator();
		else if (sectionCode.contentEquals(VitalSectionCode.Pain))
			validator = new VitalPainValidator();
		else if (sectionCode.contentEquals(VitalSectionCode.Respiration))
			validator = new VitalRespirationValidator();
		else if (sectionCode.contentEquals(VitalSectionCode.Temperature))
			validator = new VitalTemperatureValidator();
		else if (sectionCode.contentEquals(VitalSectionCode.Weight))
			validator = new VitalWeightValidator();
		else if (sectionCode.contentEquals(VitalSectionCode.Height))
			validator = new VitalHeightValidator();

		return validator;

	}

	public static DailyEventValidator getDailyEventsValdiator() {
		DailyEventValidator validator = new DailyEventValidator();
		return validator;
	}
	
}
