package com.agilex.healthcare.mobilehealthplatform.validator;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.agilex.healthcare.mobilehealthplatform.domain.ValidationError;

public class ValidatorHelper {
	
	public static ValidationError validateIsNotNull(Object object, ValidationError validationError) {
		ValidationError error = null;
		if(object == null) {
			error = validationError;
		}
		return error;
	}
	
	public static ValidationError validateIsNotBlankOrNull(String string, ValidationError validationError) {
		ValidationError error = null;
		if(string == null || string.length() == 0) {
			error = validationError;
		}
		return error;
	}

	public static ValidationError validateDateIsNotNull(Date date, ValidationError validationError) {
		ValidationError error = null;
		if(date == null) {
			error = validationError;
		}
		return error;
	}
	
	public static ValidationError validateInclusiveTextLength(String text, int length, ValidationError validationError) {
		ValidationError error = null;
		if (text != null && text.length() > length) {
			error = validationError;
		}
		return error;
	}
	
	public static ValidationError validateInclusiveNumericBounds(int value, int upperBound, int lowerBound, ValidationError validationError) {
		ValidationError error = null;
		if(value < lowerBound || value > upperBound) {
			error = validationError;
		}
		return error;
	}
	
	public static ValidationError validateInclusiveNumericBounds(double value, double upperBound, double lowerBound, ValidationError validationError) {
		ValidationError error = null;
		if(value < lowerBound || value > upperBound) {
			error = validationError;
		}
		return error;
	}
	
	public static ValidationError validateNonNegative(int value, ValidationError validationError) {
		ValidationError error = null;
		if(value < 0) {
			error = validationError;
		}
		return error;
	}
	
	public static ValidationError validateNonNegative(double value, ValidationError validationError) {
		ValidationError error = null;
		if(value < 0) {
			error = validationError;
		}
		return error;
	}
	
	public static boolean isPhoneNumberLengthValid(String phoneNumber) {

		if (phoneNumber.length() < 10 || phoneNumber.length() > 50) {
			return false;
		}
		
		return true;
	}
	
	public static boolean isPhoneNumberHasMinDigits(String phoneNumber) {
		int count = 0;
		boolean result = false;
		
		for (int i = 0 ; i < phoneNumber.length() ; i++) { 
			if (phoneNumber.charAt(i) >= '0' && phoneNumber.charAt(i) <= '9') {
				if (++count >= 10) {
					result = true;
					break;
				}
			}
		}
		
		return result;
	}
	
	public static boolean isPhoneNumberValidCharacters(String phoneNumber) {
		
		Pattern pattern = Pattern.compile("^[x0-9\\.\\-\\(\\)\\+\\s]+$");
		Matcher matcher = pattern.matcher(phoneNumber);
		
		if (!matcher.matches()) {
			return false;
		}
		return true;
	}
	
	public static boolean isEmailLengthValid(String email) {
		
		if (email.length() < 3 || email.length() > 50) {
			return false;
		}
		return true;
	}

	public static boolean isEmailAddressFormatValid(String email) {
		Pattern pattern = Pattern.compile(".*\\.\\..*");
		Matcher matcher = pattern.matcher(email);
		
		if (matcher.matches()) {
			return false;
			//error.setErrorMessage("Email address must not contain two adjacent dots");
		} else {
			pattern = Pattern.compile("^\\..*");
			matcher = pattern.matcher(email);
			
			if (matcher.matches()) {
				return false;
				//error.setErrorMessage("Email address must start with a dot");
			} else {
                pattern = Pattern.compile("^[a-zA-Z0-9\\-!#%&':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\\\._`\\{\\|\\}~@]*[a-zA-Z0-9\\-!#%&':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\_`\\{\\|\\}~@]+@[a-zA-Z0-9\\-:-\\[\\]]+(?:\\.[a-zA-Z0-9\\-:-]+)*$");
				matcher = pattern.matcher(email);
				
				if (!matcher.matches()) {
					return false;
					//error.setErrorMessage("Email address must be valid");
				}
			}
		}
		
		return true;
	}

}
