package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.Date;
import java.util.HashMap;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class QueryParameters {
	private HashMap<String, String> queryStringMap;

	public QueryParameters(String queryString) {
		queryStringMap = QueryParameterHelper.getQueryMap(queryString);
	}

	public String getValue(String key) {
		String value = null;
		if (NullChecker.isNotNullish(key))
			value = queryStringMap.get(key.toLowerCase());
		return value;
	}
	
	public boolean getValueAsBoolean(String key) {
		String value = getValue(key);
		boolean valueAsBoolean = Boolean.parseBoolean(value);
		return valueAsBoolean;
	}

	public void setValue(String key, String value) {
		queryStringMap.put(key, value);
	}

	public boolean doesKeyExist(String key) {
		boolean exists = false;
		if (NullChecker.isNotNullish(key))
			exists = queryStringMap.containsKey(key.toLowerCase());
		return exists;
	}

	public Date getValueAsDate(String key) {
		String rawValue = getValue(key);
		Date dtValue = null;
		if (NullChecker.isNotNullish(rawValue))
			dtValue = DateHelper.parseDate(rawValue);
		return dtValue;
	}

	public void setValueIfKeyDoesNotExist(String key, Date value) {
		setValueIfKeyDoesNotExist(key, DateHelper.formatDate(value));
	}

	public void setValueIfKeyDoesNotExist(String key, String value) {
		if (!doesKeyExist(key))
			setValue(key, value);
	}
}
