/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.HashMap;

import com.agilex.healthcare.utility.BooleanParser;
import com.agilex.healthcare.utility.NullChecker;

/**
 * 
 * @author rayj
 */
public class QueryParameterHelper {

	public static HashMap<String, String> getQueryMap(String query) {
		HashMap<String, String> map = new HashMap<String, String>();
		if (NullChecker.isNotNullish(query)) {
			String[] params = query.split("&");
			for (String param : params) {
				addParamToMap(map, param);
			}
		}
		return map;
	}

	private static void addParamToMap(HashMap<String, String> map, String param) {
		String[] paramParts = param.split("=");
		String name = paramParts[0];
		String value = null;
		if (paramParts.length >= 2) {
			value = paramParts[1];
		}
		if (NullChecker.isNotNullish(name)) {
			map.put(name.toLowerCase(), value);
		}
	}

	public static boolean parseQueryParamAsBoolean(String queryParamValue, boolean valueIfMissing, boolean valueIfEmpty) {
		if (queryParamValue == null)
			return valueIfMissing;
		else if (queryParamValue.contentEquals(""))
			return valueIfEmpty;
		else
			return BooleanParser.parse(queryParamValue, valueIfEmpty);
	}

}
