package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.Date;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class NullableValue {
	private String rawValue;

	public NullableValue(String rawValue) {
		this.rawValue = rawValue;
	}

	public boolean isNullish() {
		return NullChecker.isNullish(rawValue);
	}

	public boolean isNotNullish() {
		return NullChecker.isNotNullish(rawValue);
	}

	public String asString() {
		return rawValue;
	}

	public Integer asInteger() {
		return Integer.parseInt(rawValue);
	}

	public Date asDate() {
		return DateHelper.parseDate(rawValue);
	}
}
