package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

public class ScopeFilter {
	private String scopePreset = null;
	private String systemIdentifier = null;

	public static ScopeFilter getInstanceForScope(String scopePreset) {
		ScopeFilter filter = new ScopeFilter();
		filter.scopePreset = scopePreset;
		return filter;
	}

	public static ScopeFilter getInstanceForLongitudinalScope() {
		return getInstanceForScope(ScopePreset.longitudinal);
	}

	public static ScopeFilter getInstanceForOperationalScope() {
		return getInstanceForScope(ScopePreset.operational);
	}

	public static ScopeFilter getInstanceForSystem(DataSystem dataSystem) {
		return getInstanceForSystem(dataSystem.getSystemIdentifier());
	}

	public static ScopeFilter getInstanceForSystem(String systemIdentifier) {
		ScopeFilter filter = new ScopeFilter();
		filter.systemIdentifier = systemIdentifier;
		return filter;
	}

	public String getScopePreset() {
		return scopePreset;
	}

	public String getSystemIdentifier() {
		return systemIdentifier;
	}

	@Override
	public String toString() {
		final String template = "scope=%s;system=%s";
		return String.format(template, this.scopePreset, this.systemIdentifier);
	}
	
	public boolean isLongitudinal() {
		return ScopePreset.longitudinal.equals(scopePreset);
	}
	
	public boolean isOperational() {
		return ScopePreset.operational.equals(scopePreset);
	}

}
