package com.agilex.healthcare.mobilehealthplatform.mdws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;


@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "mdwsInfo", namespace = Namespace.MobileHealthPlatform)
public class MdwsInfo extends DomainTransferObject implements Serializable {
	private static final long serialVersionUID = 495495861698415531L;

//	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MdwsInfo.class);
	
	@XmlElement
	private String userId;
	@XmlElement
	private String username;
	@XmlElement
	private String sessionId;
	@XmlElement
	private String baseUrl;
	@XmlElement
	private MdwsKeys keys;
	
	
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public String getUsername() {
		return username;
	}
	public void setUsername(String username) {
		this.username = username;
	}
	public String getSessionId() {
		return sessionId;
	}
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}
	public String getBaseUrl() {
		return baseUrl;
	}
	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}
	public MdwsKeys getKeys() {
		return keys;
	}
	public void setKeys(MdwsKeys keys) {
		this.keys = keys;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((baseUrl == null) ? 0 : baseUrl.hashCode());
		result = prime * result + ((keys == null) ? 0 : keys.hashCode());
		result = prime * result + ((sessionId == null) ? 0 : sessionId.hashCode());
		result = prime * result + ((userId == null) ? 0 : userId.hashCode());
		result = prime * result + ((username == null) ? 0 : username.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MdwsInfo other = (MdwsInfo) obj;
		if (baseUrl == null) {
			if (other.baseUrl != null)
				return false;
		}
		else if (!baseUrl.equals(other.baseUrl))
			return false;
		if (keys == null) {
			if (other.keys != null)
				return false;
		}
		else if (!keys.equals(other.keys))
			return false;
		if (sessionId == null) {
			if (other.sessionId != null)
				return false;
		}
		else if (!sessionId.equals(other.sessionId))
			return false;
		if (userId == null) {
			if (other.userId != null)
				return false;
		}
		else if (!userId.equals(other.userId))
			return false;
		if (username == null) {
			if (other.username != null)
				return false;
		}
		else if (!username.equals(other.username))
			return false;
		return true;
	}
	@Override
	public String toString() {
		return "MdwsInfo [userId=" + userId + ", username=" + username + ", sessionId=" + sessionId + ", baseUrl=" + baseUrl + ", keys="
				+ keys + "]";
	}
}
