package com.agilex.healthcare.mobilehealthplatform.healthcheck;

import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Set;

import com.agilex.healthcare.utility.Configuration;
import com.agilex.healthcare.utility.IntegerParser;

@Deprecated
public class SystemProperties {
	
	private static final String MHP_VERSION = "MHP-version";
	private static HashMap<String, String> properties = new HashMap<String, String>();

	static {
		for (Entry<String, String> entry : System.getenv().entrySet()) {
			SystemProperties.setValue("env-" + entry.getKey(), entry.getValue());
		}
		for (Entry<Object, Object> entry : System.getProperties().entrySet()) {
			SystemProperties.setValue("property-" + entry.getKey().toString(), entry.getValue().toString());
		}
		
		SystemProperties.setValue(MHP_VERSION, Configuration.getVersion());
	}

	public static void setValue(String key, String value) {
		properties.put(key, value);
		if (isKeyToKeepMaxValueOn(key)  ) {
			String maxKey = key + "-max";
			setValue(maxKey, Integer.toString(Math.max(IntegerParser.parseInteger(value, 0), IntegerParser.parseInteger(getValue(maxKey), 0))));
		}
	}

	private static boolean isKeyToKeepMaxValueOn(String key) {
		if (key.contentEquals("ovid-cm-server-connections-used"))
			return true;
		if (key.contentEquals("ovid-cm-server-connections-free"))
			return true;
		if (key.contentEquals("ovid-cm-user-connections-used"))
			return true;
		if (key.contentEquals("ovid-cm-user-connections-free"))
			return true;
		else
			return false;
	}

	public static String getValue(String key) {
		return properties.get(key);
	}

	public static Set<Entry<String, String>> getData() {
		return properties.entrySet();
	}
}
