package com.agilex.healthcare.mobilehealthplatform.enumeration;

public enum MygoalsInventoryType {
	FEELINGS("Feelings"),
	CURRENT_AND_DESIRED_STATE("Current and Desired State"),
	REFLECTIONS("Reflections"),
	PRIORITIES("Priorities");
	
	
	private String name;
	
	private MygoalsInventoryType(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}
	
	public static MygoalsInventoryType fromString(String name) {
	    if (name != null) {
	      for (MygoalsInventoryType type : MygoalsInventoryType.values()) {
	        if (name.equalsIgnoreCase(type.name)) {
	          return type;
	        }
	      }
	    }
	    throw new IllegalArgumentException("No Enum specified for this string");
    }
	
	public String toString() {
		return name;
	}
}
