package com.agilex.healthcare.mobilehealthplatform.domain.sorting;

import java.util.Comparator;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;

public class LabTestComparator implements Comparator<LabTest>{
	public static final int EQUAL_TO = 0;
	public static final int GREATER_THAN = 1;
	public static final int LESS_THAN = -1;

	@Override
	public int compare(LabTest left, LabTest right) {
		if(left == null) 
			throw new NullPointerException("Cannot compare null Lab Tests");
		if(right == null)
			throw new NullPointerException("Cannot compare null Lab Tests");
		
		return left.getDisplayName().compareToIgnoreCase(right.getDisplayName());
	}
	
}
