package com.agilex.healthcare.mobilehealthplatform.domain.smartapps;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

public class TripleStore {
	private URI subject = null;
	private URI subjectType = null;
	private URI predicate = null;
	private Serializable object = null;

	public void setSubject(String subject) {
		setSubjectAsUri(stringToUri(subject));
	}

	public String getSubject() {
		return uriToString(getSubjectAsUri());
	}

	public void setSubjectAsUri(URI subject) {
		this.subject = subject;
	}

	public URI getSubjectAsUri() {
		return this.subject;
	}

	public void setSubjectType(String subjectType) {
		setSubjectTypeAsUri(stringToUri(subjectType));
	}

	public String getSubjectType() {
		return uriToString(getSubjectTypeAsUri());
	}

	public void setSubjectTypeAsUri(URI subjectType) {
		setSubjectType(uriToString(subjectType));
	}

	public URI getSubjectTypeAsUri() {
		return this.subjectType;
	}

	public void setPredicate(String predicate) {
		setPredicateAsUri(stringToUri(predicate));
	}

	public String getPredicate() {
		return uriToString(getPredicateAsUri());
	}

	public void setPredicateAsUri(URI predicate) {
		this.predicate = predicate;
	}

	public URI getPredicateAsUri() {
		return this.predicate;
	}

	public void setObject(Serializable object) {
		this.object = object;
	}

	public Serializable getObject() {
		return object;
	}

	private String uriToString(URI uri) {
		if (uri == null)
			return null;
		else
			return uri.toString();
	}

	private URI stringToUri(String s) {
		URI uri;
		try {
			uri = new URI(s);
		} catch (URISyntaxException e) {
			throw new RuntimeException(e);
		}
		return uri;
	}
}
